<div id="clef-tutorial">
    <div class="clef-tutorial-container">

        <div class="sub intro connect setup">
            <h1><?php _e("Clef is the best way to log in, without passwords. <br> It's <b>free</b>, and getting set up takes <b>30 seconds</b>.", "wpclef"); ?></h1>
            <div class="next-container">
                <div class="next button button-hero button-primary center"><?php _e("Finish setup", "wpclef"); ?></div>
                <p>Or <a href="https://getclef.com/wordpress" target="_blank">learn more about Clef</a></p>
            </div>
            <div class="quotes">
                <blockquote>
                    "With Clef, logging into a site feels, admittedly, <a class="highlight green" href="http://bits.blogs.nytimes.com/2013/12/18/new-clef-plug-in-lets-you-forget-about-your-password/" target="_blank">a little bit magical</a>."
                    <cite>— The New York Times</cite>
                </blockquote>
                <div class="recommended">
                <p>Recommended two-factor and security plugin by <a href="https://support.cloudflare.com/hc/en-us/articles/200908270-WordPress-Security-Can-CloudFlare-protect-me-against-WordPress-brute-force-attacks-" target="_blank">CloudFlare</a>, <a href="http://wptavern.com/wp-engine-identifies-cloud-infrastructure-providers-as-entry-point-for-recent-security-breach" target="_blank">WPEngine</a>, <a href="https://pantheon.io/docs/guides/two-factor-authentication/" target="_blank">Pantheon</a>, <a href="http://wptavern.com/password-free-login-with-clef-hits-all-the-high-notes" target="_blank">WPTavern</a>, <a href="https://www.youtube.com/watch?v=LxCuSNsGu6w" target="_blank">InMotion</a>, <a href="https://www.siteground.com/tutorials/wordpress/clef.htm" target="_blank">SiteGround</a>, <a href="https://www.a2hosting.com/kb/installable-applications/optimization-and-configuration/wordpress2/using-two-factor-authentication-in-wordpress-with-clef" target="_blank">A2 Hosting</a>, and the more than <a href="https://wordpress.org/plugins/wpclef/stats/" target="_blank">600,000 sites</a> that use Clef today.</p>
                </div>
            </div>
            <a href="#" class='skip done'><?php _e("Skip setup, I already have Clef API keys", "wpclef"); ?></a>
        </div>

        <div class="sub sync setup">
            <div class="spinner-container">
                <span class="spinner is-active"></span>
                <h2>loading</h2>
            </div>
            <iframe class="setup" src="" frameborder="0"></iframe>
        </div>

        <div class="sub invite setup">
            <h1><?php _e("Want to invite your users to Clef?", "wpclef"); ?></h1>
            <div class="invite-users-container"></div>
        </div>

        <div class="sub connect login">
            <h1><?php _e("Connect your Clef account", "wpclef"); ?></h1>
            <p><?php _e("To connect a Clef account, use the Clef app to sync with the wave below. Once you're connected, you'll be able to log in and out of your WordPress site with just your phone.", "wpclef"); ?></p>
            <div id="clef-button-target"></div>
        </div>

        <div class="sub using-clef setup connect">
            <h1><?php _e("3 tips for using Clef", "wpclef"); ?></h1>
            <h3>1. <?php _e("Sync once, log in everywhere.", "wpclef"); ?></h3>
            <p><?php _e("When you scan a Clef Wave, you'll be logged in to all of your sites on that computer. This means you don't have to keep scanning as you browse the web.", "wpclef"); ?></p>
            <h3>2. <?php _e("Log out with your phone.", "wpclef"); ?></h3>
            <p><?php _e("When you want to log out of your sites, click the logout button <b>on your phone</b>. This will log you out of all of your sites and can be done from anywhere (including after you walk away).", "wpclef"); ?></p>
            <h3>3. <?php _e("Lose your device?", "wpclef"); ?></h3>
            <p><?php _e("If you lose your device, don't fret! Just visit <a href='https://getclef.com/lost'>getclef.com/lost</a>, deactivate with your PIN, and reactivate on a new device.", "wpclef"); ?></p>
            <div class="button button-primary button-hero next"><?php _e("Got it!", "wpclef"); ?></div>
        </div>
    </div>
</div>

